use adw::prelude::*;
use gtk::glib;
use std::rc::Rc;
use crate::artilugios_af;
use crate::artilugios_ca;
use crate::menu;
use crate::db_utils;
use crate::utils;

pub fn ui_lock(nueva: bool, window: &adw::ApplicationWindow) {
    let vbox = gtk::Box::new(gtk::Orientation::Vertical, 0);
    let hb = gtk::HeaderBar::new();
    let menubutton = gtk::MenuButton::builder()
        .icon_name("open-menu-symbolic")
        .tooltip_text("Menú")
        .build();
    hb.pack_end(&menubutton);
    let pop = menu::crea_menu_lock(&window, nueva);
    menubutton.set_popover(Some(&pop));
    vbox.append(&hb);

    let tit;
    let desc;
    let lab;
    if !nueva {
        tit = "Desbloquear base de datos";
        desc = "";
        lab = "Desbloquear";
    } else {
        tit = "Nueva base de datos";
        desc = "Si no se introduce contraseña, no se cifrará la base de datos";
        lab = "Crear";
    }
    
    let vbox_sp = gtk::Box::new(gtk::Orientation::Vertical, 50);
    let passent = adw::PasswordEntryRow::builder()
        .title("Contraseña")
        .activates_default(true)
        .build();
    let passent2 = adw::PasswordEntryRow::builder()
        .title("Repetir contraseña")
        .activates_default(true)
        .build();
    let pg = adw::PreferencesGroup::new();
    pg.set_halign(gtk::Align::Center);
    pg.add(&passent);
    if nueva {
        pg.add(&passent2);
    }
    vbox_sp.append(&pg);
    let acept= gtk::Button::builder()
        .halign(gtk::Align::Center)
        .css_classes(["pill", "suggested-action"])
        .label(lab)
        .build();
    vbox_sp.append(&acept);
    let sp = adw::StatusPage::builder()
        .title(tit)
        .description(desc)
        .icon_name("org.cntait.tesoreria")
        .child(&vbox_sp)
        .build();
    vbox.append(&sp);
    let over = adw::ToastOverlay::new();
    over.set_child(Some(&vbox));
    window.set_content(Some(&over));
    passent.grab_focus();
    window.set_default_widget(Some(&acept));
    if nueva {
        passent.connect_changed(glib::clone!(
            #[weak]
            passent,
            #[weak]
            passent2,
            move |_| {
                if passent.text() == passent2.text() {
                    passent.remove_css_class("error");
                    passent2.remove_css_class("error");
                } else {
                    passent.add_css_class("error");
                    passent2.add_css_class("error");
                }
            }
        ));
        passent2.connect_changed(glib::clone!(
            #[weak]
            passent,
            #[weak]
            passent2,
            move |_| {
                if passent.text() == passent2.text() {
                    passent.remove_css_class("error");
                    passent2.remove_css_class("error");
                } else {
                    passent.add_css_class("error");
                    passent2.add_css_class("error");
                }
            }
        ));
    }
    acept.connect_clicked(glib::clone!(
        #[weak]
        window,
        move |_| {
            let pass = passent.text();
            let conn = db_utils::conn_db(&pass);
            if !nueva {
                if !db_utils::test_conn(&conn) {
                    passent.add_css_class("error");
                    let toast = adw::Toast::new("Contraseña incorrecta.");
                    toast.set_timeout(2);
                    over.add_toast(toast);
                    passent.grab_focus();
                } else {
                    princ(true, conn, &window);
                }
            } else {
                let pass2 = passent2.text();
                if pass != pass2 {
                    let toast = adw::Toast::new("Las contraseñas no coinciden.");
                    toast.set_timeout(2);
                    over.add_toast(toast);
                    passent2.grab_focus();
                } else {
                    let bloq_menu;
                    if pass == "" {
                        bloq_menu = false;
                    } else {
                        bloq_menu = true;
                    }
                    db_utils::crear_tablas(&conn);
                    princ(bloq_menu, conn, &window);
                }
            }
        }
    ));
    
    let app = window.application().unwrap();
    let act_menu = gtk::gio::SimpleAction::new("menu", None); 
    app.add_action(&act_menu);
    act_menu.connect_activate(glib::clone!(
        #[weak]
        menubutton,
        move |_,_| {
            menubutton.activate();
        }
    ));
    app.set_accels_for_action("app.menu", &["F10"]);
}

pub fn princ(bloq_menu: bool, conn: rusqlite::Connection, window: &adw::ApplicationWindow)
{
    let vbox = gtk::Box::new(gtk::Orientation::Vertical, 0);
    let pp = adw::NavigationPage::new(&vbox, "Volver");
    let nav = adw::NavigationView::new();
    nav.add(&pp);    
    let hb = gtk::HeaderBar::new();
    let menubutton = gtk::MenuButton::builder()
        .icon_name("open-menu-symbolic")
        .tooltip_text("Menú")
        .build();
    hb.pack_end(&menubutton);
    let searchbutton = gtk::ToggleButton::builder()
        .icon_name("edit-find-symbolic")
        .tooltip_text("Búsqueda")
        .build();
    hb.pack_end(&searchbutton);
    let searchentry = gtk::SearchEntry::new();
    let bar = gtk::SearchBar::builder()
        .child(&searchentry)
        .key_capture_widget(window)
        .build();
    let stack = adw::ViewStack::new();
    let switcher = adw::ViewSwitcher::builder()
        .stack(&stack)
        .policy(adw::ViewSwitcherPolicy::Wide)
        .build();
    hb.set_title_widget(Some(&switcher));
    vbox.append(&hb);
    vbox.append(&bar);
    vbox.append(&stack);
    window.set_content(Some(&nav));
    
    searchbutton
        .bind_property("active", &bar, "search-mode-enabled")
        .sync_create()
        .bidirectional()
        .build();
    searchentry.connect_search_started(glib::clone!(
        #[weak]
        searchbutton,
        move |_| {
            searchbutton.set_active(true);
        }
    ));
    searchentry.connect_stop_search(glib::clone!(
         #[weak]
        searchbutton,
        move |_| {
            searchbutton.set_active(false);
        }
    ));
        
    let conn = Rc::new(conn);
    
    let store_af = gtk::gio::ListStore::new::<gtk::StringList>();
    let store_ca = gtk::gio::ListStore::new::<gtk::StringList>();
    
    let pop = menu::crea_menu_unlock(bloq_menu, &conn, &nav, &window);
    menubutton.set_popover(Some(&pop));
    
    artilugios_af::af(&conn, &stack, &nav, &window, &searchentry, &store_af, &store_ca);
    let sl_cajas = db_utils::lista_cajas(&conn);
    if sl_cajas.n_items() == 0 {
        artilugios_ca::ca_prev(&conn, &stack, &nav, &window, &searchentry, &store_ca, &store_af);
    } else {
        artilugios_ca::ca(&conn, &stack, &nav, &window, &searchentry, &store_ca, &store_af);
    }
    
    let mut vc = Vec::new();
    let mut f = false;
    for i in 0..sl_cajas.n_items() {
        let futuro = db_utils::futuro(&conn, &sl_cajas.string(i).unwrap());
        if futuro {
            f = true;
            vc.push(sl_cajas.string(i).unwrap().to_string());
        }
    }
    if f {
        if vc.len() == 1 {
            utils::adialog(&format!("Existen movimientos con fecha posterior a la del sistema en la caja {}.", vc[0]), &window);

        } else {
            let cs = vc.join("\n");
            utils::adialog(&format!("Existen movimientos con fecha posterior a la del sistema en las siguientes cajas:\n{}", cs), &window);
        }
    }
    
    let settings = gtk::gio::Settings::new("org.cntait.tesoreria");
    let sett_switch = settings.string("switch");
    stack.set_visible_child_name(&sett_switch);
    stack.connect_visible_child_name_notify(move |stack| {
        let _ = settings.set_string("switch", &stack.visible_child_name().unwrap());
    });
    
    let app = window.application().unwrap();
    let act_af = gtk::gio::SimpleAction::new("af", None);  
    let act_ca = gtk::gio::SimpleAction::new("ca", None);
    let act_menu = gtk::gio::SimpleAction::new("menu", None);
    let act_search = gtk::gio::SimpleAction::new("search", None);
    app.add_action(&act_af);
    app.add_action(&act_ca);
    app.add_action(&act_menu);
    app.add_action(&act_search);
    act_af.connect_activate(glib::clone!(
        #[weak]
        stack,
        #[weak]
        nav,
        move |_,_| {
            if nav.visible_page().unwrap().title() == "Volver" {
                stack.set_visible_child_name("af");
            }
        }
    ));
    act_ca.connect_activate(glib::clone!(
        #[weak]
        stack,
        #[weak]
        nav,
        move |_,_| {
            if nav.visible_page().unwrap().title() == "Volver" {
                stack.set_visible_child_name("ca");
            }
        }
    ));
    act_menu.connect_activate(glib::clone!(
        #[weak]
        menubutton,
        #[weak]
        nav,
        move |_,_| {
            if nav.visible_page().unwrap().title() == "Volver" {
                menubutton.activate();
            }
        }
    ));
    act_search.connect_activate(move |_,_| {
        if nav.visible_page().unwrap().title() == "Volver" {
            bar.set_search_mode(!bar.is_search_mode());
        }
    });
    app.set_accels_for_action("app.af", &["<ctrl>Left"]);
    app.set_accels_for_action("app.ca", &["<ctrl>Right"]);
    app.set_accels_for_action("app.menu", &["F10"]);
    app.set_accels_for_action("app.search", &["<ctrl>f"]);
}
