use adw::prelude::*;
use gtk::glib;
use std::rc::Rc;
use crate::artilugios;
use crate::db_utils;
use crate::utils;

pub fn crea_menu_lock(window: &adw::ApplicationWindow, nueva: bool) -> gtk::PopoverMenu {
    let act_import = gtk::gio::SimpleAction::new("import", None);
    let act_ayuda = gtk::gio::SimpleAction::new("ayuda", None);
    let act_acerca = gtk::gio::SimpleAction::new("acerca", None);
    window.add_action(&act_import);
    window.add_action(&act_ayuda);
    window.add_action(&act_acerca);
    let menu = gtk::gio::Menu::new();
    menu.append(Some("Importar base de datos"), Some("win.import"));
    menu.append(Some("Ayuda"), Some("win.ayuda"));
    menu.append(Some("Acerca de"), Some("win.acerca"));
    if !nueva {
        let act_copia = gtk::gio::SimpleAction::new("copia", None);
        window.add_action(&act_copia);
        menu.prepend(Some("Copia de seguridad"), Some("win.copia"));
        act_copia.connect_activate(glib::clone!(
            #[weak]
            window,
            move |_,_| {
                copia(&window);
            }
        ));
    }
    act_import.connect_activate(glib::clone!(
        #[weak]
        window,
        move |_,_| {
            importar(&window);
        }
    ));
    act_ayuda.connect_activate(glib::clone!(
        #[weak]
        window,
        move |_,_| {
            ayuda(&window);
        }
    ));
    act_acerca.connect_activate(glib::clone!(
        #[weak]
        window,
        move |_,_| {
            acerca(&window);
        }
    ));
    gtk::PopoverMenu::from_model(Some(&menu))
}

pub fn crea_menu_unlock(bloq_menu: bool, conn: &Rc<rusqlite::Connection>, nav: &adw::NavigationView, window: &adw::ApplicationWindow) -> gtk::PopoverMenu {
    let act_rekey = gtk::gio::SimpleAction::new("rekey", None);
    let act_bloq = gtk::gio::SimpleAction::new("bloq", None);
    let act_copia = gtk::gio::SimpleAction::new("copia", None);
    let act_import = gtk::gio::SimpleAction::new("import", None);
    let act_ayuda = gtk::gio::SimpleAction::new("ayuda", None);
    let act_acerca = gtk::gio::SimpleAction::new("acerca", None);
    window.add_action(&act_rekey);
    let rekey_str;
    if bloq_menu {
        window.add_action(&act_bloq);
        rekey_str = "Cambiar contraseña";
    } else {
        window.remove_action("bloq");
        rekey_str = "Poner contraseña";
    }
    window.add_action(&act_copia);
    window.add_action(&act_import);
    window.add_action(&act_ayuda);
    window.add_action(&act_acerca);
    let menu = gtk::gio::Menu::new();
    menu.append(Some(rekey_str), Some("win.rekey"));
    menu.append(Some("Bloquear"), Some("win.bloq"));
    menu.append(Some("Copia de seguridad"), Some("win.copia"));
    menu.append(Some("Importar base de datos"), Some("win.import"));
    menu.append(Some("Ayuda"), Some("win.ayuda"));
    menu.append(Some("Acerca de"), Some("win.acerca"));
    let conn_clone = conn.clone();
    act_rekey.connect_activate(glib::clone!(
        #[weak]
        nav,
        #[weak]
        window,
        move |_,_| {
            rekey(bloq_menu, &conn_clone, &nav, &window);
        }
    ));
    act_bloq.connect_activate(glib::clone!(
        #[weak]
        window,
        move |_,_| {
            artilugios::ui_lock(false, &window);
        }
    ));
    act_copia.connect_activate(glib::clone!(
        #[weak]
        window,
        move |_,_| {
            copia(&window);
        }
    ));
    act_import.connect_activate(glib::clone!(
        #[weak]
        window,
        move |_,_| {
            importar(&window);
        }
    ));
    act_ayuda.connect_activate(glib::clone!(
        #[weak]
        window,
        move |_,_| {
            ayuda(&window);
        }
    ));
    act_acerca.connect_activate(glib::clone!(
        #[weak]
        window,
        move |_,_| {
            acerca(&window);
        }
    ));
    gtk::PopoverMenu::from_model(Some(&menu))
}

fn rekey(cif: bool, conn: &Rc<rusqlite::Connection>, nav: &adw::NavigationView, window: &adw::ApplicationWindow) {
    let vbox = gtk::Box::new(gtk::Orientation::Vertical, 0);
    let hb = adw::HeaderBar::new();
    vbox.append(&hb);
    let pp = adw::PreferencesPage::new();
    let passent_old = adw::PasswordEntryRow::builder()
        .title("Contraseña actual")
        .activates_default(true)
        .build();
    let pg_old = adw::PreferencesGroup::new();
    if cif {
        pg_old.add(&passent_old);
        pp.add(&pg_old);
    }
    let passent = adw::PasswordEntryRow::builder()
        .title("Nueva contraseña")
        .activates_default(true)
        .build();
    let passent2 = adw::PasswordEntryRow::builder()
        .title("Repetir nueva contraseña")
        .activates_default(true)
        .build();
    let pg = adw::PreferencesGroup::new();
    pg.add(&passent);
    pg.add(&passent2);
    pp.add(&pg);
    let acept= gtk::Button::builder()
        .halign(gtk::Align::Center)
        .css_classes(["pill", "suggested-action"])
        .label("Aplicar")
        .build();
    let pga = adw::PreferencesGroup::new();
    pga.add(&acept);
    pp.add(&pga);
    vbox.append(&pp);
    let over = adw::ToastOverlay::new();
    over.set_child(Some(&vbox));
    let tit = if cif { "Cambiar contraseña" } else { "Poner contraseña" };
    let page = adw::NavigationPage::new(&over, tit);
    nav.push(&page);
    acept.grab_focus();
    window.set_default_widget(Some(&acept));
    let conn_clone = conn.clone();
    let window_clone = window.clone();
    let nav_clone = nav.clone();
    passent.connect_changed(glib::clone!(
        #[weak]
        passent,
        #[weak]
        passent2,
        move |_| {
            if passent.text() == passent2.text() {
                passent.remove_css_class("error");
                passent2.remove_css_class("error");
            } else {
                passent.add_css_class("error");
                passent2.add_css_class("error");
            }
        }
    ));
    passent2.connect_changed(glib::clone!(
        #[weak]
        passent,
        #[weak]
        passent2,
        move |_| {
            if passent.text() == passent2.text() {
                passent.remove_css_class("error");
                passent2.remove_css_class("error");
            } else {
                passent.add_css_class("error");
                passent2.add_css_class("error");
            }
        }
    ));
    acept.clone().connect_clicked(move |_| {
        let pass_old = passent_old.text();
        let pass = passent.text();
        let pass2 = passent2.text();
        let toast = adw::Toast::new("");
        if pass != pass2 {
            toast.set_title("Las nuevas contraseñas no coinciden.");
        } else {
            if cif {
                if pass_old == "" {
                    passent_old.add_css_class("error");
                    toast.set_title("Debes introducir la contraseña acutal.");
                } else if pass_old == pass {
                    toast.set_title("La nueva contraseña debe ser diferente.");
                } else {
                    let conn_aux = db_utils::conn_db(&pass_old);
                    if conn_aux.query_row("SELECT name FROM sqlite_schema", [], |_| Ok(())).is_err() {
                        passent_old.add_css_class("error");
                        toast.set_title("Contraseña incorrecta.");
                    } else {
                        if pass != "" {
                            let _ = conn_clone.pragma_update(Some(rusqlite::MAIN_DB.to_str().unwrap()),"rekey", pass.to_string());
                            nav_clone.pop();
                            return;
                        } else {
                            let new_conn = db_utils::export_db(&conn_clone, &pass);
                            artilugios::princ(false, new_conn, &window_clone);
                            nav_clone.pop();
                            return;
                        }
                    }
                }
            } else {
                if pass == "" {
                    passent.add_css_class("error");
                    passent2.add_css_class("error");
                    toast.set_title("Debes introducir una contraseña.");
                } else {
                    let new_conn = db_utils::export_db(&conn_clone, &pass);
                    artilugios::princ(true, new_conn, &window_clone);
                    nav_clone.pop();
                    return;
                }
            }
        }
        toast.set_timeout(2);
        over.add_toast(toast);
    });
}

fn copia(window: &adw::ApplicationWindow) {
    let now = glib::DateTime::now_local().unwrap();
    let dialog = gtk::FileDialog::new();
    let init = format!("{}-{:02}-{:02}_tesoreria.db", now.year(), now.month(), now.day_of_month());
    dialog.set_initial_name(Some(&init));
    let window_clone = window.clone();
    dialog.save(Some(window), gtk::gio::Cancellable::NONE, move |file| {
        if let Ok(file) = file {
            let path = glib::home_dir().into_os_string().into_string().unwrap() + db_utils::DB_REL_DIR + db_utils::DB_FILE;
            match std::fs::copy(path, file.path().unwrap()) {
                Ok(_) => {}
                Err(_) => { utils::adialog("No se ha podido guardar la copia en la ubicación indicada.", &window_clone); }
            }
        }
    });
}

fn importar(window: &adw::ApplicationWindow) {
    let ad = adw::AlertDialog::new(Some("Importar base de datos"), Some("Esto eliminará la base de datos actual. Si no lo has hecho ya, haz una copia de seguridad antes de proceder."));
    ad.add_responses(&[("canc", "Cancelar"), ("acept", "Aceptar")]);
    ad.set_default_response(Some("acept"));
    ad.set_response_appearance("acept", adw::ResponseAppearance::Destructive);
    ad.present(Some(window));
    let window_clone = window.clone();
    ad.connect_response(Some("acept"), move |_, _| {
        let filter = gtk::FileFilter::new();
        filter.add_suffix("db");
        let dialog = gtk::FileDialog::new();
        dialog.set_default_filter(Some(&filter));
        dialog.set_initial_name(None);
        let window_clone2 = window_clone.clone();
        dialog.open(Some(&window_clone), gtk::gio::Cancellable::NONE, move |file| {
            if let Ok(file) = file {
                let path = file.path().unwrap();
                let conn_import = rusqlite::Connection::open(&path).unwrap();
                if !db_utils::test_conn(&conn_import) {
                    let adp = adw::AlertDialog::new(Some("Importar base de datos"), None);
                    adp.add_responses(&[("canc", "Cancelar"), ("acept", "Aceptar")]);
                    adp.set_default_response(Some("acept"));
                    adp.set_response_appearance("acept", adw::ResponseAppearance::Destructive);
                    let pg = adw::PreferencesGroup::new();
                    let pass = adw::PasswordEntryRow::builder()
                        .title("Contraseña")
                        .activates_default(true)
                        .build();
                    pg.add(&pass);
                    adp.set_extra_child(Some(&pg));
                    adp.present(Some(&window_clone2));
                    adp.connect_response(Some("acept"), move |_, _| {
                        let _ = conn_import.pragma_update(Some(rusqlite::MAIN_DB.to_str().unwrap()),"key", pass.text().to_string());
                        if !db_utils::test_conn(&conn_import) {
                            utils::adialog("Error en la contraseña o en el archivo.", &window_clone2);
                        } else {
                            import_cont(&path, &conn_import, &window_clone2, &pass.text());
                        }
                    });
                } else {
                    import_cont(&path, &conn_import, &window_clone2, "");
                }
            }
        });
    });
}

fn import_cont(path: &std::path::Path, conn_import: &rusqlite::Connection, window: &adw::ApplicationWindow, pass: &str) {
    let mut ts = 0;
    let mut v1 = 0;
    let mut stmt = conn_import.prepare("SELECT name FROM sqlite_schema WHERE type ='table'").unwrap();
    let mut rows = stmt.query([]).unwrap();
    while let Some(row) = rows.next().unwrap() {
        let m: String = row.get(0).unwrap();
        if m == "afiliacion" || m == "cotizaciones" || m == "etiquetas" {
            ts += 1;
        }
        if m == "altas" || m == "bajas" || m == "cotizaciones" {
            v1 += 1;
        }
    }
    if ts != 3 && v1 != 3 {
        utils::adialog("Archivo incorrecto.", window);
        return;
    }
    let path_app = glib::home_dir().into_os_string().into_string().unwrap() + db_utils::DB_REL_DIR + db_utils::DB_FILE;
    match std::fs::copy(path, path_app) {
        Ok(_) => {
            let b = if pass == "" { false } else { true };
            let conn = db_utils::conn_db(pass);
            if v1 == 3 && ts != 3 {
                db_utils::v1_v2(&conn);
            }
            artilugios::princ(b, conn, window);
        }
        Err(_) => { utils::adialog("No se ha podido copiar el archivo.", window); }
    }
}

fn ayuda(window: &adw::ApplicationWindow) {
    let launcher = gtk::UriLauncher::new("help:tesoreria");
    launcher.launch(Some(window), gtk::gio::Cancellable::NONE, |_| {});
}

fn acerca(window: &adw::ApplicationWindow) {
    let dialog = gtk::AboutDialog::builder()
        .transient_for(window)
        .modal(true)
        .program_name("Tesorería CNT-AIT")
        .version(env!("CARGO_PKG_VERSION"))
        .website("https://apptesoreria.cntait.org")
        .license_type(gtk::License::Gpl30)
        .authors(["Grupo TICs CNT-AIT"])
        .logo_icon_name("org.cntait.tesoreria")
        .build();
    dialog.present();
}
