mod artilugios;
mod artilugios_af;
mod artilugios_ca;
mod menu;
mod db_utils;
mod utils;
mod pages_af;
mod pages_ca;
mod ie_csvs;

use adw::prelude::*;
use gtk::glib;

fn main() -> glib::ExitCode {    
    let application = adw::Application::builder()
        .application_id("org.cntait.tesoreria")
        .build();
    application.connect_activate(|app| {
        let settings = gtk::gio::Settings::new("org.cntait.tesoreria");
        let width = settings.int("ventana-anchura");
        let height = settings.int("ventana-altura");
        let window = adw::ApplicationWindow::builder()
            .application(app)
            .default_width(width)
            .default_height(height)
            .title("Tesorería CNT-AIT")
            .build();
        if db_utils::exist_db() {
            let (conn, cif) = db_utils::state_cif_db();
            if cif {
                artilugios::ui_lock(false, &window);
            } else {
                if db_utils::es_v1(&conn) {
                    db_utils::v1_v2(&conn);
                }
                artilugios::princ(false, conn, &window);
            }
        } else {
            artilugios::ui_lock(true, &window);
        }
        window.present();
        window.connect_close_request(move |window|
        {
            let width = window.width();
            let height = window.height();
            let _ = settings.set_int("ventana-anchura", width);
            let _ = settings.set_int("ventana-altura", height);
            false.into()
        });
        let css = "columnview cell { padding: 0px 0px; } columnview listview box { padding: 8px 6px; } button.bnopad {padding: 4px 3px;}";
        let provider = gtk::CssProvider::new();
        provider.load_from_string(css);
        gtk::style_context_add_provider_for_display(&gtk::gdk::Display::default().unwrap(), &provider, gtk::STYLE_PROVIDER_PRIORITY_USER);
    });
    application.run()
}
