use adw::prelude::*;
use gtk::glib;

pub const MESES: &[&str] = &["", "Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
pub const COTIZA: &[&str] = &["Metálico", "Transferencia", "Transferencia empresa", "Domiciliación", "Exención"];

pub fn check_date (texto: &str) -> bool {
    if texto.len() == 0 {
        return true;
    }
    if texto.len() == 10 && texto.chars().count() == 10 {
        let day: i32 = texto[0..2].parse().unwrap_or_else(|_| {32});
        let month: i32 = texto[3..5].parse().unwrap_or_else(|_| {13});
        let year: i32 = texto[6..10].parse().unwrap_or_else(|_| {0});
        if glib::DateTime::from_utc(year, month, day, 0, 0 , 0.0).is_ok(){
            if texto.chars().nth(2).unwrap() == '/' && texto.chars().nth(5).unwrap() == '/' {
                return true;
            }
        }
    }
    false
}

pub fn adialog(texto: &str, window: &adw::ApplicationWindow) {
    let dialog = adw::AlertDialog::builder()
        .heading("Aviso")
        .body(texto)
        .build();
    dialog.add_response("canc", "Cerrar");
    dialog.present(Some(window)); 
}

pub fn nokeys<T: IsA<gtk::Widget>>(w: &T) {
    let keycontroller = gtk::EventControllerKey::new();
    keycontroller.set_propagation_phase(gtk::PropagationPhase::Capture);
    keycontroller.connect_key_pressed(|_,_,_,_| {
        true.into()
    });
    w.add_controller(keycontroller);
}

pub fn calendario<T: IsA<gtk::Widget> + IsA<gtk::Editable>>(ent: &T, oblig: bool) -> gtk::Popover {
    let cal = gtk::Calendar::new();
    let pop = gtk::Popover::builder()
        .child(&cal)
        .build();
    let ent_clone = ent.clone();
    let cal_clone = cal.clone();
    pop.connect_map(move |_| {
        texto_a_calendario(&ent_clone, &cal_clone);
    });
    let ent_clone = ent.clone();
    cal.connect_day_selected(move |cal| {
        ent_clone.set_text(&format!("{:02}/{:02}/{}", cal.day(), cal.month()+1, cal.year()));
    });
    let ent_clone = ent.clone();
    cal.connect_next_month(move |cal| {
        ent_clone.set_text(&format!("{:02}/{:02}/{}", cal.day(), cal.month()+1, cal.year()));
    });
    let ent_clone = ent.clone();
    cal.connect_prev_month(move |cal| {
        ent_clone.set_text(&format!("{:02}/{:02}/{}", cal.day(), cal.month()+1, cal.year()));
    });
    let ent_clone = ent.clone();
    cal.connect_next_year(move |cal| {
        ent_clone.set_text(&format!("{:02}/{:02}/{}", cal.day(), cal.month()+1, cal.year()));
    });
    let ent_clone = ent.clone();
    cal.connect_prev_year(move |cal| {
        ent_clone.set_text(&format!("{:02}/{:02}/{}", cal.day(), cal.month()+1, cal.year()));
    });
    ent.connect_changed(move |ent| {
        if !check_date(&ent.text())  || (ent.text() == "" && oblig) {
            ent.add_css_class("error");
        } else {
            ent.remove_css_class("error");
        }
    });
    pop
}

fn texto_a_calendario<T: IsA<gtk::Editable>>(ent: &T, cal: &gtk::Calendar) {
    let texto: String = ent.text().chars().filter(|&c| !c.is_whitespace()).collect();
    if texto.len() == 10 {
        cal.set_year(texto[6..10].parse().unwrap_or_else(|_| {
            cal.year()
        }));
        cal.set_month(texto[3..5].parse().unwrap_or_else(|_| {
            cal.month()+1
        })-1_i32);
        cal.set_day(texto[0..2].parse().unwrap_or_else(|_| {
            cal.day()
        }));
        let f = format!("{:02}/{:02}/{}", cal.day(), cal.month()+1, cal.year());
        if texto != f {
            ent.set_text(&f);
        }
    } else {
        ent.set_text(&format!("{:02}/{:02}/{}", cal.day(), cal.month()+1, cal.year()));
    }
}

pub fn convert_fech(f: &str) -> String {
    let sep = if f.contains('/') { '/' } else { '-' };
    let nsep = if sep == '/' { '-' } else { '/' };
    let mut iter = f.split(sep);
    let a = iter.next().unwrap();
    let b = iter.next().unwrap();
    let c = iter.next().unwrap();
    format!("{}{}{}{}{}", c, nsep, b, nsep, a)
}

pub fn menusuf_calendar(ent: &adw::EntryRow, pop: &gtk::Popover) {
    let mb = gtk::MenuButton::builder()
        .icon_name("x-office-calendar-symbolic")
        .valign(gtk::Align::Center)
        .css_classes(["flat"])
        .tooltip_text("Calendario")
        .popover(pop)
        .build();
    ent.add_suffix(&mb);
}

pub fn recrea_lista(store: &gtk::gio::ListStore, sl: &gtk::StringList){
    let mut pos = u32::MAX;
    let mut saldo = 0.0;
    let fecha = sl.string(1).unwrap();
    for i in 1..store.n_items() {
        if convert_fech(&fecha) >= convert_fech(&store.item(i).and_downcast::<gtk::StringList>().unwrap().string(1).unwrap()) {
            pos = i;
            let saldo_s = store.item(i).and_downcast::<gtk::StringList>().unwrap().string(6).unwrap();
            saldo = saldo_s.split(" €").next().unwrap().replace(",", ".").replace("€", "").parse::<f32>().unwrap();
            break;
        }
    }
    if pos == u32::MAX {
        pos = store.n_items();
    }
    store.insert(pos, sl);
    comun_recrea(&store, pos+1, saldo);
}

pub fn recrea_lista_upd(store: &gtk::gio::ListStore, sl: &gtk::StringList, sln: &gtk::StringList) {
    let pos_init = store.find(sl).unwrap();
    store.remove(pos_init);
    let mut pos = u32::MAX;
    let mut saldo = 0.0;
    let fecha = sln.string(1).unwrap();
    let num = sln.string(0).unwrap().parse::<u32>().unwrap();
    for i in 1..store.n_items() {
        if convert_fech(&fecha) >= convert_fech(&store.item(i).and_downcast::<gtk::StringList>().unwrap().string(1).unwrap()) {
            if convert_fech(&fecha) == convert_fech(&store.item(i).and_downcast::<gtk::StringList>().unwrap().string(1).unwrap()) {
                if num < store.item(i).and_downcast::<gtk::StringList>().unwrap().string(0).unwrap().parse().unwrap() {
                    continue;
                }
            }
            pos = i;
            let saldo_s = store.item(i).and_downcast::<gtk::StringList>().unwrap().string(6).unwrap();
            saldo = saldo_s.split(" €").next().unwrap().replace(",", ".").replace("€", "").parse::<f32>().unwrap();
            break;
        } 
    }
    if pos == u32::MAX {
        pos = store.n_items();
    }
    let mut pos_saldo = pos;
    if pos < pos_init {
        pos_saldo = pos_init + 1;
        if pos_saldo <= store.n_items() {
            let saldo_s = store.item(pos_saldo).and_downcast::<gtk::StringList>().unwrap().string(6).unwrap();
            saldo = saldo_s.split(" €").next().unwrap().replace(",", ".").replace("€", "").parse::<f32>().unwrap();
        } else {
            pos_saldo = pos_init;
            saldo = 0.0;
        }
    }
    store.insert(pos, sln);
    comun_recrea(&store, pos_saldo+1, saldo);
}

pub fn recrea_lista_del(store: &gtk::gio::ListStore, sl: &gtk::StringList) {
    let pos = store.find(sl).unwrap();
    store.remove(pos);
    let mut saldo = 0.0;
    if pos  < store.n_items() {
        let saldo_s = store.item(pos).and_downcast::<gtk::StringList>().unwrap().string(6).unwrap();
        saldo = saldo_s.split(" €").next().unwrap().replace(",", ".").replace("€", "").parse::<f32>().unwrap();
    }
    comun_recrea(&store, pos, saldo);
}

fn comun_recrea(store: &gtk::gio::ListStore, pos: u32, mut saldo: f32) {
    for i in (1..pos).rev() {
        let sli = store.item(i).and_downcast::<gtk::StringList>().unwrap();
        let imp_s = sli.string(5).unwrap();
        let imp = imp_s.split(" €").next().unwrap().replace(",", ".").replace("€", "").parse::<f32>().unwrap();
        saldo += imp;
        let saldo_s = format!("{:.2} €", saldo).replace(".", ",");
        sli.splice(6, 1, &[&saldo_s]);
        //Utilizo remove + insert porque con splice no se actualiza automáticamente la lista
        store.remove(i);
        store.insert(i, &sli);
    }
}

pub fn entry_calendar (text: &str) -> gtk::Entry {
    let ent = gtk::Entry::builder()
        .secondary_icon_name("x-office-calendar-symbolic")
        .width_chars(9)
        .max_width_chars(9)
        .text(text)
        .build();
    let pop = calendario(&ent, true);
    pop.set_parent(&ent);
    let ent_cone = ent.clone();
    pop.connect_closed(move |_| {
       ent_cone.grab_focus_without_selecting();
       ent_cone.set_position(-1);
    });
    let pop_clone = pop.clone();
    ent.connect_icon_press(move |_,_| {
        pop_clone.popup();
    });
    ent
}

pub fn crea_hb<T: IsA<gtk::Widget>, S: IsA<gtk::Widget>>(t1: &str, w1: &T, t2: &str, w2: &S) -> gtk::Box {
    let hbox = gtk::Box::builder()
        .orientation(gtk::Orientation::Horizontal)
        .spacing(10)
        .margin_start(10)
        .margin_end(10)
        .halign(gtk::Align::Center)
        .build();
    let hbox1 = gtk::Box::new(gtk::Orientation::Horizontal, 1);
    let lab1 = gtk::Label::new(Some(t1));
    hbox1.append(&lab1);
    hbox1.append(w1);
    hbox.append(&hbox1);    
    let hbox2 = gtk::Box::new(gtk::Orientation::Horizontal, 1);
    let lab2 = gtk::Label::new(Some(t2));
    hbox2.append(&lab2);
    hbox2.append(w2);
    hbox.append(&hbox2);
    hbox
}

pub fn mes_texto_a_cod(texto: &str) -> String {
    if texto != "" {
        let mut spl = texto.split_whitespace();
        let m = spl.next().unwrap();
        let index = MESES.iter().position(|&r| r == m).unwrap();
        let y = spl.next().unwrap();
        format!("{}{:02}", y, index)
    } else {
        texto.to_string()
    }
}

pub fn mes_cod_a_texto(cod: &str) -> String {
    let y = &cod[0..4];
    let index: usize = cod[4..6].parse().unwrap();
    let m = MESES[index];
    format!("{} {}", m, y)
}

pub fn format_euros (v: f32) -> String {
    if v.fract() == 0.0 { 
        format!("{:.0} €", v) 
    } else { 
        format!("{:.2} €", v).replace(".", ",") 
    }
}

pub fn euros_to_f(v: &str) -> Result<f32, std::num::ParseFloatError> {
    v.split(" €").next().unwrap()
     .replace("," ,".")
     .parse()
}

pub fn pos_cc(store: &gtk::gio::ListStore, cc: &str) -> Option<u32> {
    store.find_with_equal_func(|slo| {
        let ccp = slo.downcast_ref::<gtk::StringList>().unwrap().string(0).unwrap();
        if ccp == cc {
            true
        } else {
            false
        }
    })
}

pub fn suma_mes(val: &str) -> String {
    if val != "" {
        let mut iter = val.split_whitespace();
        let mut mes = iter.next().unwrap();
        let mut anyo = iter.next().unwrap().parse::<i32>().unwrap();
        if mes == "Diciembre" {
            mes = "Enero";
            anyo += 1; 
        } else {
            let mes_pos = MESES.iter().position(|&r| r == mes).unwrap() + 1;
            mes = MESES[mes_pos];
        }
        format!("{} {}", mes, anyo)
    } else {
        val.to_string()
    }
}

pub fn quita_tildes(s: &str) -> String {
    s.replace('á', "a")
     .replace('é', "e")
     .replace('í', "i")
     .replace('ó', "o")
     .replace('ú', "u")
     .replace('ü', "u")
}

pub fn select_key_cv(cv: &gtk::ColumnView, key: &str) {
    let m = cv.model().unwrap();
    let cv_clone = cv.clone();
    for i in 0..m.n_items() {
        if m.item(i).and_downcast::<gtk::StringList>().unwrap().string(0).unwrap() == key {
            glib::idle_add_local_once(move|| { //Si se hace sin esto no mueve el scroll hasta i cuando baja. Lo hace hasta la anterior.
                cv_clone.scroll_to(i, None, gtk::ListScrollFlags::SELECT, None);
            });
            break;
        }
    }
}
