use adw::prelude::*;
use std::rc::Rc;
use crate::utils;
use crate::artilugios_af;
use crate::artilugios_ca;

struct CotizCSV {
    pos: u32,
    slc: gtk::StringList,
    meses: u32,
}

pub fn exp_af(window: &adw::ApplicationWindow, slmodel: &gtk::SortListModel) {
    let dialog = gtk::FileDialog::new();
    dialog.set_initial_name(Some("afiliacion.csv"));
    let window_clone = window.clone();
    let slmodel_clone = slmodel.clone();
    dialog.save(Some(window), gtk::gio::Cancellable::NONE, move |file| {
        if let Ok(file) = file {
            match csv::WriterBuilder::new().delimiter(b';').from_path(file.path().unwrap()) {
                Ok(mut wtr) => {
                    let _ = wtr.write_record(artilugios_af::COLUMNAS);
                    for i in 0..slmodel_clone.n_items() {
                        let sl = slmodel_clone.item(i).and_downcast::<gtk::StringList>().unwrap();
                        for j in 0..sl.n_items() {
                            let _ = wtr.write_field(&sl.string(j).unwrap());
                        }
                        let _ = wtr.write_record(None::<&[u8]>);
                    }
                    let _ = wtr.flush();
                }
                Err(_) => { utils::adialog("No se ha podido guardar en la ubicación indicada.", &window_clone); }
            }
        }
    });
}

pub fn imp_af(conn: &Rc<rusqlite::Connection>, window: &adw::ApplicationWindow, store: &gtk::gio::ListStore) {
    let filter = gtk::FileFilter::new();
    filter.add_suffix("csv");
    let dialog = gtk::FileDialog::new();
    dialog.set_default_filter(Some(&filter));
    dialog.set_initial_name(None);
    let conn_clone = conn.clone();
    let window_clone = window.clone();
    let store_clone = store.clone();
    dialog.open(Some(window), gtk::gio::Cancellable::NONE, move |file| {
        if let Ok(file) = file {
            match csv::ReaderBuilder::new().delimiter(b';').flexible(true).from_path(file.path().unwrap()) {
                Ok(mut rdr) => {
                    let mut vs = Vec::new();
                    let mut vcc: Vec<String> = Vec::new();
                    let mut error = false;
                    let mut fila = 1;
            'fuera: for result in rdr.records() {
                        if result.is_err() { 
                            utils::adialog("No se ha podido abrir el archivo.", &window_clone);
                            break;
                        }
                        fila += 1;
                        let sl = gtk::StringList::new(&[]);
                        let r = result.unwrap();
                        for i in 0..r.len() {
                            if i == 0 { // Carné
                                if &r[i] == "" {
                                    utils::adialog(&format!("No existe carné en la fila {}. No se ha importado ningún dato.", fila), &window_clone);
                                    error = true;
                                    break 'fuera;
                                }
                                for j in 0..store_clone.n_items() {
                                    let cc = store_clone.item(j).and_downcast::<gtk::StringList>().unwrap().string(0).unwrap();
                                    if cc == r[i] {
                                        utils::adialog(&format!("El carné «{}» (fila {}) ya existe. No se ha importado ningún dato.", cc, fila), &window_clone);
                                        error = true;
                                        break 'fuera;
                                    }
                                }
                                let rep = vcc.iter().position(|c| c == &r[i]);
                                if rep.is_some() {
                                    utils::adialog(&format!("El carné «{}» está reptido en las filas {} y {}. No se ha importado ningún dato.", &r[i], rep.unwrap()+2, fila), &window_clone);
                                    error = true;
                                    break 'fuera;
                                }
                                vcc.push(r[i].to_string());
                            } else if i == 3 { // Forma cotización
                                if &r[i] != "" && !utils::COTIZA.contains(&&r[i]) {
                                    utils::adialog(&format!("Forma cotización incorrecta en fila {}. No se ha importado ningún dato.", fila), &window_clone);
                                    error = true;
                                    break 'fuera;
                                }
                            } else if i == 4 { // Cuota
                                if &r[i] != "" {
                                    let p = utils::euros_to_f(&r[i]);
                                    if p.is_err() {
                                        utils::adialog(&format!("Cuota incorrecta en fila {}. No se ha importado ningún dato.", fila), &window_clone);
                                        error = true;
                                        break 'fuera;
                                    }
                                    let cuota = utils::format_euros(p.unwrap());
                                    sl.append(&cuota);
                                    continue;
                                }
                            } else if i == 5 || i == 17 || i == 19 { // Fecha
                                if !utils::check_date(&r[i]) {
                                    utils::adialog(&format!("Formato fecha incorrecto en fila {}. No se ha importado ningún dato.", fila), &window_clone);
                                    error = true;
                                    break 'fuera;
                                }
                            } else if i == 18 { // Mes cotizado (se obvia)
                                sl.append("");
                                continue;
                            }
                            sl.append(&r[i]);
                        }
                        if sl.n_items() < artilugios_af::COLUMNAS.len() as u32 {
                            let dif = artilugios_af::COLUMNAS.len() - sl.n_items() as usize;
                            let vemp = vec![""; dif];
                            sl.splice(sl.n_items(), 0, &vemp);
                        } else if sl.n_items() > artilugios_af::COLUMNAS.len() as u32 {
                            utils::adialog(&format!("Datos fuera de rango en fila {}. No se ha importado ningún dato.", fila), &window_clone);
                            error = true;
                            break 'fuera;
                        }
                        vs.push(sl);
                    }
                    if !error {
                        store_clone.splice(0, 0, &vs);
                        let tx = conn_clone.unchecked_transaction().unwrap();
                        for sl in vs {
                            let cuota = match utils::euros_to_f(&sl.string(4).unwrap()) {
                                Ok(num) => num,
                                Err(_)  => 0.0,
                            };
                            tx.execute(
                                "INSERT INTO afiliacion (cc, apellidos, nombre, mcotiza, cuota, fnacimiento, telefono, email, dir, loc, barrio, obs, ocu, sec, centro, dirc, obsc, afiliado, fechabaja) 
                                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)",
                                [&sl.string(0).unwrap().to_string(), &sl.string(1).unwrap().to_string(), &sl.string(2).unwrap().to_string(), &sl.string(3).unwrap().to_string(), &cuota.to_string(), &sl.string(5).unwrap().to_string(), &sl.string(6).unwrap().to_string(), &sl.string(7).unwrap().to_string(), &sl.string(8).unwrap().to_string(), &sl.string(9).unwrap().to_string(), &sl.string(10).unwrap().to_string(), &sl.string(11).unwrap().to_string(), &sl.string(12).unwrap().to_string(), &sl.string(13).unwrap().to_string(), &sl.string(14).unwrap().to_string(), &sl.string(15).unwrap().to_string(), &sl.string(16).unwrap().to_string(), &sl.string(17).unwrap().to_string(), &sl.string(19).unwrap().to_string()],
                            ).unwrap();
                        }
                        let _ = tx.commit();
                    }
                }
                Err(_) => { utils::adialog("No se ha podido abrir el archivo.", &window_clone); }
            }
        }
    });
}

pub fn exp_ca(window: &adw::ApplicationWindow, fstore: &gtk::FilterListModel, cv: &gtk::ColumnView) {
    let dialog = gtk::FileDialog::new();
    dialog.set_initial_name(Some("extracto.csv"));
    let window_clone = window.clone();
    let fstore_clone = fstore.clone();
    let cv_clone = cv.clone();
    dialog.save(Some(window), gtk::gio::Cancellable::NONE, move |file| {
        if let Ok(file) = file {
            match csv::WriterBuilder::new().delimiter(b';').from_path(file.path().unwrap()) {
                Ok(mut wtr) => {
                    let vis = cv_clone.columns().item(6).and_downcast::<gtk::ColumnViewColumn>().unwrap().is_visible();
                    let e;
                    if vis {
                        e = 0;
                        let _ = wtr.write_record(artilugios_ca::COLUMNAS);
                    } else {
                        e = 1;
                        let _ = wtr.write_record(&artilugios_ca::COLUMNAS[..artilugios_ca::COLUMNAS.len()-1]);
                    }
                    for i in (0..fstore_clone.n_items()).rev() {
                        let sl = fstore_clone.item(i).and_downcast::<gtk::StringList>().unwrap();
                        for j in 0..sl.n_items()-e {
                            let _ = wtr.write_field(&sl.string(j).unwrap());
                        }
                        let _ = wtr.write_record(None::<&[u8]>);
                    }
                    let _ = wtr.flush();
                }
                Err(_) => { utils::adialog("No se ha podido guardar en la ubicación indicada.", &window_clone); }
            }
        }
    });
}

pub fn imp_ca(conn: &Rc<rusqlite::Connection>, window: &adw::ApplicationWindow, wb: &adw::WrapBox, store: &gtk::gio::ListStore, store_af: &gtk::gio::ListStore) {
    let filter = gtk::FileFilter::new();
    filter.add_suffix("csv");
    let dialog = gtk::FileDialog::new();
    dialog.set_default_filter(Some(&filter));
    dialog.set_initial_name(None);
    let conn_clone = conn.clone();
    let window_clone = window.clone();
    let wb_clone = wb.clone();
    let store_clone = store.clone();
    let store_af_clone = store_af.clone();
    dialog.open(Some(window), gtk::gio::Cancellable::NONE, move |file| {
        if let Ok(file) = file {
            match csv::ReaderBuilder::new().delimiter(b';').flexible(true).from_path(file.path().unwrap()) {
                Ok(mut rdr) => {
                    let mut vs = Vec::new();
                    let mut vcot: Vec<CotizCSV> = Vec::new();
                    let mut error = false;
                    let mut fila = 1;
            'fuera: for result in rdr.records() {
                        if result.is_err() { 
                            utils::adialog("No se ha podido abrir el archivo.", &window_clone);
                            break;
                        }
                        fila += 1;
                        let sl = gtk::StringList::new(&[]);
                        let r = result.unwrap();
                        for i in 0..r.len() {
                            if i == 0 || i == 6 { // Num y saldo (se obvian)
                                sl.append("");
                                continue;
                            } else if i == 1 { // Fecha
                                if !utils::check_date(&r[i]) || &r[i] == "" {
                                    utils::adialog(&format!("Formato fecha incorrecto en fila {}. No se ha importado ningún dato.", fila), &window_clone);
                                    error = true;
                                    break 'fuera;
                                }
                            } else if i == 4 { // Etiquetas
                                if &r[i] == "Cotización" {
                                    let mut encont = false;
                                    let mut pos = 0;
                                    let spl = r[3].split_whitespace();
                                    for p in spl {
                                        let opos = utils::pos_cc(&store_af_clone, &p);
                                        if opos != None {
                                            pos = opos.unwrap();
                                            encont = true;
                                            break;
                                        }
                                    }
                                    if !encont {
                                'encont: for i in 0..store_af_clone.n_items() {
                                            let ape = utils::quita_tildes(&store_af_clone.item(i).and_downcast::<gtk::StringList>().unwrap().string(1).unwrap().to_lowercase());
                                            let nom = utils::quita_tildes(&store_af_clone.item(i).and_downcast::<gtk::StringList>().unwrap().string(2).unwrap().to_lowercase());
                                            let wc = nom.split_whitespace().count() + ape.split_whitespace().count();
                                            if wc > 0 {
                                                let na = format!("{} {}", nom, ape);
                                                let an = format!("{} {}", ape, nom);
                                                let ws: Vec<_> = r[3].split_whitespace().collect();
                                                for wind in ws.windows(wc) {
                                                    let wj = utils::quita_tildes(&wind.join(" ").to_lowercase());
                                                    if strsim::normalized_levenshtein(&wj, &na) > 0.9 {
                                                        pos = i;
                                                        encont = true;
                                                        break 'encont;
                                                    } else if strsim::normalized_levenshtein(&wj, &an) > 0.9 {
                                                        pos = i;
                                                        encont = true;
                                                        break 'encont;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    if encont {
                                        let slc = store_af_clone.item(pos).and_downcast::<gtk::StringList>().unwrap();
                                        if slc.string(4).unwrap() == "" {
                                            utils::adialog(&format!("La persona encontrada no tiene cuota. Fila {}. No se ha importado ningún dato.", fila), &window_clone);
                                            error = true;
                                            break 'fuera;
                                        } else if slc.string(3).unwrap() == utils::COTIZA[4] {
                                            utils::adialog(&format!("La persona encontrada es exanta. Fila {}. No se ha importado ningún dato.", fila), &window_clone);
                                            error = true;
                                            break 'fuera;

                                        } else if slc.string(18).unwrap() == "" {
                                            utils::adialog(&format!("La persona encontrada no tiene cotizaciones previas. Fila {}. No se ha importado ningún dato.", fila), &window_clone);
                                            error = true;
                                            break 'fuera;
                                        } else {
                                            let cuota = utils::euros_to_f(&slc.string(4).unwrap()).unwrap();
                                            let imp = utils::euros_to_f(&r[5]);
                                            if !imp.is_err() {
                                                let imp = imp.unwrap();
                                                if imp % cuota == 0.0 {
                                                    let meses = imp / cuota;
                                                    vcot.push(CotizCSV{pos, slc, meses: meses as u32});
                                                } else {
                                                    utils::adialog(&format!("El importe no se corresponde con una cantidad de cuotas. Fila {}. No se ha importado ningún dato.", fila), &window_clone);
                                                    error = true;
                                                    break 'fuera;
                                                }
                                            } else {
                                                utils::adialog(&format!("Importe incorrecto en fila {}. No se ha importado ningún dato.", fila), &window_clone);
                                                error = true;
                                                break 'fuera;
                                            }
                                        }
                                    } else {
                                        utils::adialog(&format!("No se ha encontrado destino de la cotización de la fila {}. No se ha importado ningún dato.", fila), &window_clone);
                                        error = true;
                                        break 'fuera;
                                    }
                                } else if &r[i] != "" {
                                    let sle = gtk::StringList::new(&[]);
                                    let chs = wb_clone.observe_children();
                                    for j in 0..chs.n_items() { 
                                        let tgl = chs.item(j).and_downcast::<gtk::ToggleButton>().unwrap().label().unwrap();
                                        sle.append(&tgl);
                                    }
                                    let spl = r[i].split(" | ");
                                    for et in spl {
                                        let mut exist = false;
                                        for k in 0..sle.n_items() {
                                            if et == sle.string(k).unwrap() {
                                                if et == "Cotización" {
                                                    utils::adialog(&format!("La etiqueta 'Cotización' debe ir sola. Fila {}. No se ha importado ningún dato.", fila), &window_clone);
                                                    error = true;
                                                    break 'fuera;
                                                }
                                                exist = true;
                                                break;
                                            }
                                        }
                                        if !exist {
                                            utils::adialog(&format!("Etiqueta incorrecta en fila {}. No se ha importado ningún dato.", fila), &window_clone);
                                            error = true;
                                            break 'fuera;
                                        }
                                    }
                                }
                            } else if i == 5 { // Importe
                                let p = utils::euros_to_f(&r[i]);
                                if p.is_err() {
                                    utils::adialog(&format!("Importe incorrecto en fila {}. No se ha importado ningún dato.", fila), &window_clone);
                                    error = true;
                                    break 'fuera;
                                }
                                let importe = format!("{:.2} €", p.unwrap()).replace(".", ",");
                                sl.append(&importe);
                                continue;
                            }
                            sl.append(&r[i]);
                        }
                        if sl.n_items() < artilugios_ca::COLUMNAS.len() as u32 {
                            let dif = artilugios_ca::COLUMNAS.len() - sl.n_items() as usize;
                            let vemp = vec![""; dif];
                            sl.splice(sl.n_items(), 0, &vemp);
                        } else if sl.n_items() > artilugios_ca::COLUMNAS.len() as u32 {
                            utils::adialog(&format!("Datos fuera de rango en fila {}. No se ha importado ningún dato.", fila), &window_clone);
                            error = true;
                            break 'fuera;
                        }
                        vs.push(sl);
                    }
                    if !error {
                        let caja = store_clone.item(0).and_downcast::<gtk::StringList>().unwrap().string(0).unwrap();
                        let tx = conn_clone.unchecked_transaction().unwrap();
                        for sl in vs {
                            let fecha = utils::convert_fech(&sl.string(1).unwrap());
                            let imp = utils::euros_to_f(&sl.string(5).unwrap()).unwrap();
                            tx.execute(
                                &format!("INSERT INTO '{}' (fecha, factura, concepto, etiquetas, importe) 
                                VALUES (?, ?, ?, ?, ?)", caja),
                                [&fecha, &sl.string(2).unwrap().to_string(), &sl.string(3).unwrap().to_string(), &sl.string(4).unwrap().to_string(), &imp.to_string()],
                            ).unwrap();
                            let num = conn_clone.last_insert_rowid();
                            sl.splice(0, 1, &[&num.to_string()]);
                            utils::recrea_lista(&store_clone, &sl);
                            if sl.string(4).unwrap() == "Cotización" {
                                let mut cot_ant = vcot[0].slc.string(18).unwrap().to_string();
                                for _ in 0..vcot[0].meses {
                                    cot_ant = utils::suma_mes(&cot_ant);
                                    let cod_mes = utils::mes_texto_a_cod(&cot_ant);
                                    tx.execute(
                                        "INSERT INTO cotizaciones (cc, num, caja, mes) 
                                        VALUES (?, ?, ?, ?)",
                                        [&vcot[0].slc.string(0).unwrap().to_string(), &num.to_string(), &caja.to_string(), &cod_mes],
                                    ).unwrap();
                                }
                                vcot[0].slc.splice(18, 1, &[&cot_ant]);
                                store_af_clone.remove(vcot[0].pos);
                                store_af_clone.insert(vcot[0].pos, &vcot[0].slc);
                                vcot.remove(0);
                            }
                        }
                        let _ = tx.commit();
                    }
                }
                Err(_) => { utils::adialog("No se ha podido abrir el archivo.", &window_clone); }
            }
        }
    });
}
